#include "CameraCBuffer.hlsli"

Texture2D SourceTex : register(t0);
Texture2D<float2> VelocityMap : register(t1);

SamplerState PointSampler : register(s0);
SamplerState LinearSampler : register(s1);
SamplerState AnisoSampler : register(s2);

#include "MotionBlur.hlsli"

struct PSInput {
	float4 PositionViewportS : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

static const int numSamples = 8;

float4 main(PSInput input) : SV_TARGET
{
	// Get the initial color at this pixel.  
	float2 curTexCoords = input.TexCoords;
	float4 color = SourceTex.SampleLevel(LinearSampler, curTexCoords, 0);
	
	float2 velocity = VelocityMap.SampleLevel(LinearSampler, curTexCoords, 0);
	
	velocity /= numSamples;

	// Sample the color buffer along the velocity vector.
	for(int i = 1; i < numSamples; ++i)  
	{
		curTexCoords += velocity;
		float4 curColor = SourceTex.SampleLevel(LinearSampler, curTexCoords, 0);
		
		// Add the current color to the color sum.  
		color += curColor;  
	}
	
	// Average all of the samples to get the final blur color.  
	float4 finalColor = color / numSamples;
	return finalColor;
}